### Android ZPL SDK 说明文档

#### 1 SDK 加载及使用

##### 1.1 加载

- 将jar包拷贝到app/libs文件夹下

- 在app中的build.gradle加入下面的代码

  ```java
  android{
    sourceSets {
          main {
              jniLibs.srcDirs = ['libs']
          }
      }
  }
  implementation  files('libs/ZPL_SDK_V1.01.jar')
  implementation 'com.github.barteksc:pdfium-android:1.9.0'//SDK需要的依赖库
  ```



##### 1.2 使用

- 我们所用的接口都在ZPLPrinterHelper这个类中。

  ```java
  ZPLPrinterHelper mZPL = ZPLPrinterHelper.getZPL(mContext)
  mContext：上下文对象。  
  ```

  

#### 2 SDK 连接接口

##### 2.1 蓝牙连接接口	

- 描述

  ```java
  int PortOpen(String portSetting)
  ```

- 参数

  ```java
  portSetting：”Bluetooth,”+MAC。（MAC：蓝牙地址）
  ```

- 返回

  ```java
  0：连接成功，-1：连接失败。
  ```

  

##### 2.2 WIFI连接接口	

- 描述

  ```java
  int PortOpen(String portSetting)
  ```

- 参数

  ```java
  portSetting：“WiFi,”+IP+”,”+PortNumber
  IP：打印机的IP地址。
  PortNumber：端口。 默认：9100  
  ```

- 返回

  ```java
  0：连接成功，-1：连接失败。
  ```

  

##### 2.3 USB连接接口	

- 描述

  ```java
  int PortOpen(UsbDevice usbdevice)
  ```

- 参数

  ```java
  usbdevice：UsbDevice的对象 
  ```

- 返回

  ```java
  0：连接成功，-1：连接失败。
  ```

  

##### 2.4 断开连接接口	

- 描述

  ```java
  boolean PorClose()
  ```

- 参数

  ```java
  无
  ```

- 返回

  ```java
  true：断开成功，false：断开失败。
  ```

  

#### 3 SDK 打印接口

##### 3.1 标签开始

- 描述

  ```java
  int start()
  ```

- 参数

  ```java
  无
  ```

- 返回

  ```java
  大于0：正常，否则异常。
  ```

- 例子

  ```java
  mZPL.start();
  mZPL.printText(“0”,”0”,5,”N”,3,”TEXT”);
  mZPL.end();
  ```

  

##### 3.2 设置坐标

- 描述

  ```java
  int setXY(String x,String y)
  ```

- 参数

  ```java
  X：横坐标。
  Y：纵坐标。
  ```

- 返回

  ```java
  大于0：正常，否则异常。
  ```

  

##### 3.3 标签结束

- 描述

  ```java
  int end()
  ```

- 参数

  ```java
  无
  ```

- 返回

  ```java
  大于0：正常，否则异常。
  ```

- 例子

  ```java
  mZPL.start();
  mZPL.printText(“0”,”0”,5,”N”,3,”TEXT”);
  mZPL.end();
  ```

  

##### 3.4 字段开头指令

- 描述

  ```java
  int FD(String fd)
  ```

- 参数

  ```java
  fd：文本。
  ```

- 返回

  ```java
  大于0：正常，否则异常。
  ```

- 例子

  ```java
  mZPL.start();
  mZPL.setXY(“0”,”0”);
  mZPL.FD(“TEXT”);
  mZPL.FS();
  mZPL.end();
  ```

  

##### 3.5 字段结束指令

- 描述

  ```java
  int FS()
  ```

- 参数

  ```java
  无
  ```

- 返回

  ```java
  大于0：正常，否则异常。
  ```

- 例子

  ```java
  mZPL.start();
  mZPL.setXY(“0”,”0”);
  mZPL.FD(“TEXT”);
  mZPL.FS();
  mZPL.end();
  ```

  

##### 3.6 打印宽度

- 描述

  ```java
  int PW(String pw)
  ```

- 参数

  ```java
  pw：宽度（单位：dots）
  ```

- 返回

  ```java
  大于0：正常，否则异常。
  ```

- 例子

  ```java
  mZPL.start();
  mZPL.PW(“100”)
  mZPL.setXY(“0”,”0”);
  mZPL.FD(“TEXT”);
  mZPL.FS();
  mZPL.end();
  ```

  

##### 3.7 打印方向和对齐方式

- 描述

  ```java
  int FW(String rotate,String justification)
  ```

- 参数

  ```
  rotate：打印方向，取值如下：
  	N = normal
  	R = rotated 90 degrees
  	I = inverted 180 degrees
  	B = bottom-up 270 degrees, read from bottom up
  Justification：对其方式，取值如下：
  	0 = left justification
  	1 = right justification
  	2 = auto justification (script dependent)
  ```

- 返回

  ```java
  大于0：正常，否则异常。
  ```

- 例子

  ```java
  mZPL.start();
  mZPL.FW(“N”,”0”)
  mZPL.setXY(“0”,”0”);
  mZPL.FD(“TEXT”);
  mZPL.FS();
  mZPL.end();
  ```

  

##### 3.8 打印直线

- 描述

  ```java
  int printLine(String w,String h,String t,String c,String r)
  ```

- 参数

  ```
  w：直线的宽度。（1~32000单位 点）
  H：直线的高度。（1~32000单位 点）
  T：线条的宽度。（1~32000单位 点）
  C：线条的颜色：
  	B=black；（默认：B）
  	W=white；
  R：圆角的弧度（0~8）
  ```

- 返回

  ```java
  大于0：正常，否则异常。
  ```

- 例子

  ```java
  mZPL.start();
  mZPL.setXY(“0”,”0”);
  mZPL.printLine(“100”,”2”,”2”,”B”,”0”)//打印100点宽，2点高的横线
  mZPL.end();
  ```

  

##### 3.9 打印圆

- 描述

  ```java
  int printCircle(String d,String t,String c)
  ```

- 参数

  ```
  d：圆的直径（3~4095）。
  t：边框厚度（1~4095）。
  C：线条颜色：
  	B=black；（默认：B）
  	W=white；
  ```

- 返回

  ```java
  大于0：正常，否则异常。
  ```

- 例子

  ```java
  mZPL.start();
  mZPL.setXY(“0”,”0”);
  mZPL.printCircle(“100”,”2”,”B”)
  mZPL.end();
  ```

  

##### 3.10 打印斜线

- 描述

  ```java
  int printSlashLine(String w,String h,String t,String c,String o)
  ```

- 参数

  ```
  w：斜线的宽度（3~32000）。
  H：斜线的高度（3~32000）。
  T：线条宽度（1~32000）。
  C：线条颜色：（默认：B）
  	B=black；
  	W=white；
  O：斜线的方向：（默认：R）
  	R (or /) = right-leaning diagonal
  	L (or \) = left-leaning diagonal
  ```

- 返回

  ```java
  大于0：正常，否则异常。
  ```

- 例子

  ```java
  mZPL.start();
  mZPL.setXY(“0”,”0”);
  mZPL.printSlashLine(“100”,”100”,”2”,”B”,”R”)
  mZPL.end();
  ```

  

##### 3.11 设置标签原点位置

- 描述

  ```java
  int LH(String x,String y)
  ```

- 参数

  ```
  X：原点的横坐标。
  Y：原点的纵坐标。
  ```

- 返回

  ```java
  大于0：正常，否则异常。
  ```

  

##### 3.12 设置左偏移量

- 描述

  ```java
  int LS(String ls)
  ```

- 参数

  ```
  ls：偏移量（-9999~9999）负数代表向右偏移，（默认0）。
  ```

- 返回

  ```java
  大于0：正常，否则异常。
  ```

- 例子

  ```java
  mZPL.start();
  mZPL.LS(“20”)
  mZPL.printText(“100”,”100”,5,”N”,3,”TEXT”);
  mZPL.end();
  ```

  

##### 3.13 设置文本框（可自动换行）

- 描述

  ```java
  int TB(String a,String b,String c)
  ```

- 参数

  ```
  a：文字方向：
  	N = normal
  	R = rotate 90 degrees clockwise
  	I = invert 180 degrees
  	B = read from bottom up-270 degrees
  b：文本框的宽度。
  c：文本框的高度。
  ```

- 返回

  ```java
  大于0：正常，否则异常。
  ```

- 例子

  ```java
  mZPL.start();
  mZPL.TB(“N”,”300”,”300”)
  mZPL.printText(“100”,”100”,5,”N”,3,”TEXT”);
  mZPL.end();
  ```

  

##### 3.14 打印二维码

- 描述

  ```java
  int printQRcode(String x,String y,String orientation,
                  String magnification,String size,String data)
  ```

- 参数

  ```
  x：横坐标。
  y：纵坐标。
  orientation：方向（N）。
  magnification：模式：默认（2）
  	1=普通模式。
  	2=加强模式。
  size ：尺寸（1~10）。
  data:二维码的内容
  ```

- 返回

  ```java
  大于0：正常，否则异常。
  ```

- 例子

  ```java
  mZPL.start();
  mZPL.printData("^CI14\r\n");//如果二维码内容有中文，请调用这个代码。
  mZPL.printQRcode(“10”,”10”,”N”,”2”,”5”,”abc123”);
  mZPL.end();
  ```

  

##### 3.15 打印条码

- 描述

  ```java
  int printBarcode(String x,String y,int type,
                   String orientation,String height,String f,String data)
  ```

- 参数

  ```
  x：横坐标。
  y：纵坐标。
  Type：条码类型：
  	0=39
  	1=EAN-8
  	2=UPC-E
  	3=93
  	4=128
  	5=EAN-13
  orientation：方向：
  	N = normal
  	R = rotated 90 degrees (clockwise)
  	I = inverted 180 degrees
  	B = read from bottom up, 270 degrees
  Height：条码高度（1-32000）。
  F：条码内容是否见（默认Y）：
  	Y = yes
  	N = no
  ```

- 返回

  ```java
  大于0：正常，否则异常。
  ```

- 例子

  ```java
  mZPL.start();
  mZPL.printBarcode(“10”,”10”,”0”,”N”,”100”,”Y”,”123456789”);
  mZPL.end();
  ```

  

##### 3.16 打印图片

- 描述

  ```java
  void printBitmap(String x, String y, int halftoneType, Bitmap bmp)
  ```

- 参数

  ```
  x：起始的X坐标。
  y：起始的Y坐标。
  halftoneType：图片算法
  	0：二值（黑白）
  	1：抖动
  bmp：图片对象。
  ```

- 返回

  ```java
  大于0：正常，否则异常。
  ```

- 例子

  ```java
  mZPL.start();
  mZPL.printBitmap(“10”,”10”,0,bitmap);
  mZPL.end();
  ```

  

##### 3.17 发数据函数

- 描述

  ```java
  int WriteData(byte[] bData)
  ```

- 参数

  ```
  bData：需要发给打印机的数据。
  ```

- 返回

  ```java
  大于0：正常，否则异常。
  ```

- 例子

  ```java
  mZPL.WriteData(byt)
  ```

  

##### 3.18 读数据函数

- 描述

  ```java
  byte[] ReadData(int outTime)
  ```

- 参数

  ```
  outTime：超时时间（单位秒）。
  ```

- 返回

  ```java
  读取到的数据。
  ```

- 例子

  ```java
  mZPL.ReadData(2)
  ```

  

##### 3.19 打印自检页

- 描述

  ```java
  int selfTest()
  ```

- 参数

  ```
  无
  ```

- 返回

  ```java
  大于0：正常，否则异常。
  ```

- 例子

  ```java
  mZPL.selfTest()
  ```

  

##### 3.20 打印文本

- 描述：打印中文时需要选择编码，请参照例子。

  ```java
  int printText(String x,String y,int type,String orientation,int size,String data)
  ```

- 参数

  ```
  x：横坐标。
  y：纵坐标。
  type：字体（0~6：中文无效，7：中文）。
  orientation：方向。
  	N = normal
  	R = rotate 90 degrees clockwise
  	I = invert 180 degrees
  	B = read from bottom up-270 degrees
  size：字体大小。
  	1：10px。
  	2：20px。
  	3：30px。
  	4：40px。
  	5：50px。
  	6：60px。
  data：文本数据。
  ```

- 返回

  ```java
  大于0：正常，否则异常。
  ```

- 例子

  ```java
  mZPL.start();
  mZPL.printData("^CI14\r\n")//打印中文时需要加入这句
  mZPL.printText(“0”,”0”,5,”N”,3,”TEXT”);
  mZPL.end();
  ```

  

##### 3.21 打印数量和切刀

- 描述：

  ```java
  int PQ(String q,String p,String r,String o)
  ```

- 参数

  ```
  q：打印数量。
  p：暂停前或者切刀前数量。
  r：每个序列号的副本数。
  o：切刀或者暂停。
  	Y：切刀。
  	N：暂停。
  ```

- 返回

  ```java
  大于0：正常，否则异常。
  ```

- 例子

  ```java
  mZPL.start();
  mZPL.printData("^CI14\r\n")//打印中文时需要加入这句
  mZPL.printText(“0”,”0”,5,”N”,3,”TEXT”);
  mZPL.PQ(1,1,1,Y);//打印一张后切刀
  mZPL.end();
  ```

  

##### 3.22 打印模式

- 描述：

  ```java
  int setPrinterModel(String model)
  ```

- 参数

  ```
  model：
  	T = 撕扯。 
  	P = 剥离（部分机器上不可用）。
  ```

- 返回

  ```java
  大于0：正常，否则异常。
  ```

- 例子

  ```java
  mZPL.start();
  mZPL.printData("^CI14\r\n")//打印中文时需要加入这句
  mZPL.printText(“0”,”0”,5,”N”,3,”TEXT”);
  mZPL.setPrinterModel(“P”);//切换成剥离模式
  mZPL.end();
  ```

  

##### 3.23 写入RFID

- 描述：

  ```java
  int writeRFID(int address, int memory,byte[] data)
  ```

- 参数

  ```
  address：起始地址。
  	范围：大于0。(EPC区地址必须从2开始)
  memory：写入区域。 
  	0 = 保留区
  	1 = EPC区 
  	3 = User区
  data：需写入的数据。（保留区，EPC不超过12个字节，User不超过128）
  ```

- 返回

  ```java
  -1：发送失败，-2：参数错误，0：写入成功。
  ```

- 例子

  ```java
  mZPL.start();
  mZPL.writeRFID(0,1,"Test RFID".getBytes());
  mZPL.end();
  ```

  

##### 3.24 读取RFID

- 描述：

  ```java
  byte[] readRFID(int address,int length,int memory)
  ```

- 参数

  ```
  address：起始地址。
  	范围：大于0。(EPC区地址必须从2开始)
  length：读取的长度。（保留区，EPC不超过12个字节，User不超过128）
  memory：写入区域。 
  	0 = 保留区
  	1 = EPC区 
  	3 = User区
  ```

- 返回

  ```java
  读取到的数据，空表示读取失败。
  ```

- 例子

  ```java
  mZPL.start();
  mZPL.writeRFID(2,1,"中文".getBytes("GB2312"));
  mZPL.readRFID(2, 4, 1);
  mZPL.end();
  byte[] bytes = mZPL.ReadData(3);
  if (bytes!=null&&bytes.length>0){
    String hexStr = new String(bytes);
    byte[] hexByte = UtilityTooth.hexToByte(hexStr);
  	Toast.makeText(thisCon,newString(hexByte,"GB2312"),Toast.LENGTH_SHORT).show();
  }
  ```

  

##### 3.25 读取SN

- 描述：

  ```java
  String getPrinterSN()
  ```

- 参数

  ```
  无
  ```

- 返回

  ```java
  SERIAL NEMBER:SN号。
  ```

- 例子

  ```java
  mZPL.getPrinterSN();
  ```

  

##### 3.26 PDF转Bitmap

- 描述：

  ```java
  List<Bitmap> pdfToBitmap(Context context, File file, String pageNumber, int pageWidth)
  ```

- 参数

  ```
  context：上下文对象。
  file：PDF文件。
  pageNumber：需要转换的页数（"1,3-7"）。
  pageWidth：转换后bitmap的宽度。
  ```

- 返回

  ```java
  List<Bitmap>：转换后的bitmap。
  ```

- 例子

  ```java
  List<Bitmap> bitmaps = mZPL.pdfToBitmap(thisCon, file, "1", 576);
  ```

  

